// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 6
// "Woerterbuch"

class Entry {
	String key;
	String value;
	Entry(String key, String value) { this.key = key; this.value = value; }
}


class Dictionary {
	Entry[] e;
	int nextFree;
	int size;
	
	Dictionary(int size) {
		e = new Entry[size];
		this.size = size;
		nextFree = 0;
	}
	
	void insert(String key, String value) {
		if (nextFree < size) {
			int i = 0;
			while (i < nextFree && !key.equals(e[i].key)) i++;
			// i >= nextFree || key.equals(e[i].key)
			if (i >= nextFree)
				e[nextFree++] = new Entry(key, value);
			else // key.equals(e[i].key)
				e[i].value = value;
		} else
			Out.println("-- dictionary full");
	}
	
	String lookup(String key) {
		for (int i = 0; i < nextFree; i++)
			if (key.equals(e[i].key)) return e[i].value;
		return null;
	}
}


public class A6 {
	
	public static void main(String args[]) {
		Dictionary d = new Dictionary(100);
		In.open("input.txt");
		String key = In.readWord();
		while (!key.equals("LOOKUP")) {
			String value = In.readWord();
			d.insert(key, value);
			key = In.readWord();
		}
		key = In.readWord();
		while (In.done()) {
			String value = d.lookup(key);
			Out.println(key + " => " + value);
			key = In.readWord();
		}
		In.close();
	}
}


/*
Sample input
Haus house
Buch book
Baum tree
Sonne sun
Mond moon

LOOKUP
Buch
Vogel
Mond
*/